/*--------------------------------------
    common.c

    Mark & Marc,  5/31/93 12:51:50
    contains utility routines for the entire unit
*/

#include "icon.h"

extern EventRecordPtr       fEventPtr;
extern word                 fUserID;
extern word                 edResFileID;
extern long                 remHelpID;
extern fPrivateDataRec	    PrivPB;
extern fResDataRec          DataPB;
extern fResRefRec		    RefPB;

void MakeGlobalRect(Rect *inR, Rect *outR)
{
    BlockMove(inR, outR, 8L);
    LocalToGlobal(&outR->v1);
    LocalToGlobal(&outR->v2);
}

word getVid(void)
{
	return (GetMasterSCB() & 0x80) ? 2 : 1;
}

word setMaxOf(word a, word b)
{
    return (a > b) ? a : b;
}

word setMinOf(word a, word b)
{
    return (a > b) ? b : a;
}

void stuffRect(Rect *r, word l, word t, word w, word h)
{
    r->h1 = l;
    r->v1 = t;
    r->h2 = l + w;
    r->v2 = t + h;
}

handle loadEdRes(word id, word resType)
{
word    retErr;

    DataPB.pCount = 5;
	DataPB.resType = resType;
	DataPB.resID = (long) id;
	DataPB.special = 0;
	DataPB.resFileID = edResFileID;
	retErr = fSpecialMagic(&DataPB);
	DataPB.special = 1;
	retErr = fSpecialMagic(&DataPB);
	return DataPB.resData;
}

void unloadEdRes(word id, word resType)
{
word    retErr;

    DataPB.pCount = 5;
	DataPB.resType = resType;
	DataPB.resID = (long) id;
	DataPB.special = 3;
	DataPB.resFileID = edResFileID;
	retErr = fSpecialMagic(&DataPB);
}

void checkData(GrafPortPtr winP) {

privateDataHndl	privH;
privateDataPtr  privP;
long			size;

	privH = getPrivate(winP);
    privP = *privH;
	if (privP->flag == 0x8001) {
		size = GetHandleSize(privP->editH);
        HUnlock(privP->resData);
		SetHandleSize(size, privP->resData);
		HandToHand((Handle) privP->editH, privP->resData, size);
        HLock(privP->resData);
		RefPB.pCount = 2;
		RefPB.resType = rIcon;
		RefPB.resID = privP->resID;
		fWriteResource(&RefPB);
		privP->flag = 0x8000;	/* set dirty flag to 0 */
	}
	else {
		if (privP->flag == 0x0001) {
		    privP->resData = RebuildBundle(privP->structH);
			RefPB.pCount = 2;
			RefPB.resType = rBundle;
			RefPB.resID = privP->resID;
			fWriteResource(&RefPB);
			privP->flag = 0x0000;
		}
	}
}

privateDataHndl getPrivate(GrafPortPtr winP) {

	PrivPB.pCount = 4;
	(GrafPortPtr) PrivPB.winPtr = winP;
	fGetPrivateData(&PrivPB);
	return (privateDataHndl) PrivPB.Data;
}


/*  Off Port Magic-  yet another form of hell  */

void CreateOffPort(word width, word height, GrafPort ***pMapH) {

GrafPortPtr		oPort;
GrafPortHndl	portH;
LocInfo		    locInfo;
Handle		    pixImageHndl;
Ptr			    pixImagePtr;

	oPort = GetPort();
	portH = *pMapH = 0L;
	portH = (GrafPortHndl) NewHandle(sizeof(GrafPort), fUserID, 0x8018, 0L);
	HLock((Handle) portH);
	OpenPort(*portH);
	locInfo.portSCB = GetMasterSCB();
	locInfo.boundsRect.h1 = 0;
	locInfo.boundsRect.h2 = width;
	locInfo.boundsRect.v1 = 0;
	locInfo.boundsRect.v2 = height;
	locInfo.width = ((width / 4) + 7) & 0xfff8;
	pixImageHndl = NewHandle((long) (locInfo.width * height), fUserID, 0x8018, 0L);
	pixImagePtr = *pixImageHndl;
	locInfo.ptrToPixImage = pixImagePtr;
	SetPortLoc(&locInfo);
	SetPortRect(&locInfo.boundsRect);
	ClipRect(&locInfo.boundsRect);
	SetVisRgn(GetClipHandle());
	EraseRect(&locInfo.boundsRect);
	SetPort(oPort);
	HUnlock((Handle) portH);
	*pMapH = portH;
}

void AdjustOffPort(GrafPort **pMapH, word width, word height) {

GrafPortPtr		oPort, pMapP;
LocInfo		    locInfo;
Handle		    h, pixImageHndl;
Ptr			    pixImagePtr;

	oPort = GetPort();
	pMapP = *pMapH;
	SetPort(pMapP);
	h = FindHandle(pMapP->portInfo.ptrToPixImage);
	if (h)
		DisposeHandle(h);
	locInfo.portSCB = GetMasterSCB();
	locInfo.boundsRect.h1 = 0;
	locInfo.boundsRect.h2 = width;
	locInfo.boundsRect.v1 = 0;
	locInfo.boundsRect.v2 = height;
	locInfo.width = ((width / 4) + 7) & 0xfff8;
	pixImageHndl = NewHandle((long) (locInfo.width * height), fUserID, 0x8018, 0L);
	pixImagePtr = *pixImageHndl;
	locInfo.ptrToPixImage = pixImagePtr;
	SetPortLoc(&locInfo);
	SetPortRect(&locInfo.boundsRect);
	ClipRect(&locInfo.boundsRect);
	SetVisRgn(GetClipHandle());
	EraseRect(&locInfo.boundsRect);
	SetPort(oPort);
	HUnlock((Handle) pMapH);
}

word UpdateEditor(GrafPortPtr winP) {

	BeginUpdate(winP);
	EndUpdate(winP);
	return -1;
}

word EditorMenu(EventRecord *event) {

WindowPtr		winP;
privateDataHndl	privH;
privateDataPtr	privP;
	
	winP = FrontWindow();
	privH = getPrivate(winP);
    privP = *privH;
	switch ((short) event->wmTaskData) {
		case MAKEMASKITEM:			/* create mask */
			MakeMask(privP);
			break;
		case COPYMASKITEM:			/* copy icon to mask */
			break;
		case IMPORTITEM:			/* import icon */
			break;
	}
	return 0;
}

#pragma databank	1
#pragma toolparms	1
void DrawProc(void) {
	DrawEditor();
}
#pragma databank	0
#pragma toolparms	0
